unit Screensaver; //Screensaver auslesen und aus Listbox starten D.B. 03.2010

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ShellApi;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    procedure ListBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure listfiles(dir, mask : string);
var
  rec   : TSearchRec;
  found : Integer;
begin
  if dir[Length(dir)] <> '\' then dir := dir + '\';
  found := findfirst(dir + mask, faAnyFile, rec);
  try
    while found = 0 do
    begin
      Application.ProcessMessages;
      if (rec.Attr and faDirectory <= 0) then
      Form1.ListBox1.Items.Add(dir + rec.Name );
      found := findnext(rec);
    end;
  finally
    findclose(rec);
  end;
  found := findfirst(dir + '*.*', faAnyFile, rec);
  try
    while found = 0 do
    begin
      if (rec.Attr and faDirectory > 0) and (rec.Name[1] <> '.') then
        ListFiles(dir + rec.Name, mask);
      found := findnext(rec);
    end;
  finally
    findclose(rec);
  end;
end;

procedure TForm1.ListBox1MouseDown(Sender: TObject; Button: TMouseButton;
          Shift: TShiftState; X, Y: Integer);
var
  I : Integer;
begin
  for I := 0 to (ListBox1.Items.Count - 1) do
  begin
    if ListBox1.Selected[I] then
    begin // ausgewhlten screensaver starten
      ShellExecute(Application.Handle, 'open', PChar(ListBox1.Items.Strings[ListBox1.ItemIndex]), Nil, Nil, SW_SHOW);
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ListBox1.Clear;
  ListFiles('c:\','*.scr');
  Form1.Caption := IntToStr(ListBox1.Items.Count)+ ' Stck ' + '   Copyright (c) 2010 by D.B. ';
end;

end.




