unit Unit1;          //01.2014 D.B.

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Timer1: TTimer;
    Button2: TButton;
    StatusBar1: TStatusBar;
    Button3: TButton;
    Label2: TLabel;
    Timer2: TTimer;
    Label3: TLabel;
    Button4: TButton;
    Button5: TButton;
    GroupBox1: TGroupBox;
    SpeedButton1: TSpeedButton;
    Label4: TLabel;
    Button6: TButton;
    Label5: TLabel;
    Timer3: TTimer;
    Button7: TButton;
    Label6: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure Button7Click(Sender: TObject);


  private
       Merk:TDateTime;   //fr Stopuhr
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    FStartTime: TDateTime;   //fr Uhrzeit

  end;

var
  Form1: TForm1;
  startzeit,
  endzeit : Cardinal;  // fr Stopuhr

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var
  CLFRgn: HRgn;  //abgerundete Ecken
  i : Integer;
begin
  CLFRgn := CreateRoundRectRgn(0,0,Form1.Width,Form1.Height,20,20);  //Formular mit abgerundeten Ecken
  SetWindowRgn(Form1.Handle,CLFRgn,True);  //Formular mit abgerundeten Ecken

  //Button1 ein anderes Style verpassen
  SetWindowLong(Button1.Handle, GWL_EXSTYLE,
  GetWindowLong(Button1.Handle,GWL_EXSTYLE) or WS_EX_CLIENTEDGE);
  SetWindowPos(Button1.Handle, 0, 0, 0, 0, 0,
  swp_DrawFrame or swp_NoMove or swp_NoSize or swp_NoZOrder);

  //********************** fr Button5 mehrzeilige Beschriftung *******************
 // var i : Integer;
  i:=GetWindowLong(Button5.Handle,GWL_STYLE );
  SetWindowLong (Button5.Handle,GWL_STYLE , i or
  BS_MULTILINE);
  Button4.Caption := 'Info'#13#10 + ' '#13#10 + 'Zeile 3' + #13#10 + 'zeile 4'; //usw.
//****************** fr Button5 mehrzeilige Beschriftung Ende ******************

end;


//die aktuelle uhrzeit aktualisieren
procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Label1.Caption := FormatDateTime('hh:nn:ss', now )+'  (Label1)';  //in Label1 anzeigen

  Label2.caption := 'Uhrzeit' + FormatDateTime(' hh:nn:ss', now)+'  &&  Datum ' + DateToStr(date)+'  (Label2)';    //in Label2 anzeigen

  Label3.caption := 'Uhrzeit' + FormatDateTime(' hh:nn:ss', now)+#10#13+'Datum ' + DateToStr(date)+'  (Label3)';    //in Label3 anzeigen

  Form1.Caption := 'Uhrzeit in Form1.Caption:  ' + FormatDateTime('hh:nn:ss', now) + '                                                   '+
  '                  &                                               '+
  '                                      Datum: ' + DateToStr(date); //Uhrzeit und Datum in Form1.Caption anzeigen

  StatusBar1.Panels[0].Text := ' Uhrzeit' + FormatDateTime('   hh:nn:ss', now);    //in Statuszeile (Feld1) anzeigen

  StatusBar1.Panels[1].Text := ' Datum  ' + DateToStr(date);    //in Statuszeile (Feld2) anzeigen

  StatusBar1.Panels[2].Text := FormatDateTime('" " dd  mmmm  yyyy " " hh:mm:ss ', Now );   //dd  mmmm  yyyy " " hh:mm:ss:zzz mit msek-Anzeige

  StatusBar1.Panels[3].Text := 'Beides in der StatusBar1 - Datum:  ' + DateToStr(date) +'  &  Uhrzeit: ' + FormatDateTime('   hh:nn:ss', now);//in Statuszeile (Feld4) anzeigen

  Button2.Caption :=  DateToStr(date); //Datum auf Button2

  Button3.Caption :=  FormatDateTime(' hh:nn:ss', now); //Zeit auf Button3

  Button4.Caption :=  'Uhrzeit'+ FormatDateTime(' hh:nn:ss', now)+ ' && Datum ' + DateToStr(date);

//********************** siehe Button5 mehrzeilige Beschriftung *********************************************************************************
  Button5.Caption :=  'Uhrzeit'+ FormatDateTime(' hh:nn:ss', now)+ #13#10 + ' && ' + #13#10 + ' Datum ' + DateToStr(date)+ #13#10 + ' Zeile4 ';
//********************** siehe Button5 mehrzeilige Beschriftung *********************************************************************************

  GroupBox1.Caption:= FormatDateTime('" " dd  mmmm  yyyy " " hh:mm:ss ', Now );   //dd  mmmm  yyyy " " hh:mm:ss:zzz mit msek-Anzeige

  SpeedButton1.Caption := FormatDateTime('" " dd  mmmm  yyyy " " hh:mm:ss ', Now )+ #13#10 + ' && ' + #13#10 + ' SpeedButton1';//dd  mmmm  yyyy " " hh:mm:ss:zzz mit msek-Anzeige
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  Form1.Close;
end;

//##############################################################################

//Analoguhr
procedure TForm1.Timer2Timer(Sender: TObject);  //fr Analoguhr
var winkel: Real;
    x, y, x1, y1, r, i: Integer; //fr Uhr
    hour, min, sec, msec: Word;
begin
  //Form1.Caption := DateTimeToStr(Now);

         (*alte Grafik lschen*)
        Refresh;

        (*Einpassen des Kreises in das Fenster*)
         if Width <= Height
                then r := Width div 6  //Wert vergrssern um Uhr kleiner zu machen
                else r := Height div 6;   //Wert vergrssern um Uhr kleiner zu machen

       (*Umwandlung in einzelne Integer-Werte*)
        DecodeTime(Now, hour, min, sec, msec);

        (*Sekundenzeiger*)
        winkel := sec * (((2 * pi) / 60)) - pi / 2;

        x := Trunc(Cos(winkel)* r);
        y := Trunc(Sin(winkel)* r);

        x := x + (Width div 2);
        y := y + (Height div 2);

        Canvas.Moveto(Width div 2, Height div 2);
        Canvas.LineTo(x, y);


        (*Minutenzeiger*)
        winkel := min * (((2 * pi) / 60)) - pi / 2;

        x := Trunc(Cos(winkel)* r);
        y := Trunc(Sin(winkel)* r);

        x := x + (Width div 2);
        y := y + (Height div 2);

        Canvas.Moveto(Width div 2, Height div 2);
        Canvas.LineTo(x, y);
        Canvas.Moveto((Width div 2) + 1, (Height div 2) + 1);
        Canvas.LineTo(x, y);
        Canvas.Moveto((Width div 2) + 1, (Height div 2) - 1);
        Canvas.LineTo(x, y);
        Canvas.Moveto((Width div 2 - 1), (Height div 2) + 1);
        Canvas.LineTo(x, y);
        Canvas.Moveto((Width div 2 - 1), (Height div 2) - 1);
        Canvas.LineTo(x, y);


        (*Stundenzeiger*)
        if hour > 12 then hour := hour -12;
        winkel := (hour * (2 * pi) / 12) + (min * (2 * pi) / 720) - pi / 2;
        //Canvas.Brush.Color := clred;

        x := Trunc(Cos(winkel)* r * 0.61);
        y := Trunc(Sin(winkel)* r * 0.61);

        x := x + (Width div 2);
        y := y + (Height div 2);

        Canvas.Moveto(Width div 2, Height div 2);
        Canvas.LineTo(x, y);
        Canvas.Moveto((Width div 2) + 1, (Height div 2) + 1);
        Canvas.LineTo(x, y);
        Canvas.Moveto((Width div 2) + 1, (Height div 2) - 1);
        Canvas.LineTo(x, y);
        Canvas.Moveto((Width div 2 - 1), (Height div 2) + 1);
        Canvas.LineTo(x, y);
        Canvas.Moveto((Width div 2 - 1), (Height div 2) - 1);
        Canvas.LineTo(x , y);
        Canvas.Moveto((Width div 2) + 2, (Height div 2) + 2);
        Canvas.LineTo(x, y);
        Canvas.Moveto((Width div 2) + 2, (Height div 2) - 2);
        Canvas.LineTo(x , y);
        Canvas.Moveto((Width div 2 - 2), (Height div 2) + 2);
        Canvas.LineTo(x, y);
        Canvas.Moveto((Width div 2 - 2), (Height div 2) - 2);
        Canvas.LineTo(x , y);

        (*Mittelpunkt*)
        Canvas.Ellipse((Width div 2)-4, (Height div 2)-4,(Width div 2)+ 4,(Height div 2)+ 4);

        (*Ziffernstriche*)
         i := 0;
         FOR i := 0 TO 11 DO
       begin
         winkel := i * (((2 * pi) / 12)) - pi / 2;

         x := Trunc(Cos(winkel)* 1.1*r);
         x1 := Trunc(Cos(winkel)* r);
         y := Trunc(Sin(winkel)* 1.1*r);
         y1 := Trunc(Sin(winkel)* r);

         x := x + (Width div 2);
         x1 := x1 + (Width div 2);
         y := y + (Height div 2);
         y1 := y1 + (Height div 2);
         Canvas.Moveto(x, y);
         Canvas.LineTo(x1, y1);
       end;

        (*Minutenpunkte*)
         i := 0;
         FOR i := 0 TO 59 DO
       begin
         winkel := i * (((2 * pi) / 60)) - pi / 2;
         //Canvas.Brush.Color := clyellow;

         x := Trunc(Cos(winkel)* 1.1*r);
         y := Trunc(Sin(winkel)* 1.1*r);

         x := x + (Width div 2);
         y := y + (Height div 2);
         Canvas.Pixels[x, y] := clwhite;
         Canvas.Ellipse(x-2, y-2,x+2,y+2);
         Canvas.Brush.Color := clred;   //
       end;
   end;         //Analoguhr Ende auf Form1

//##############################################################################
// einfache Stopuhr
// private
//       Merk:TDateTime;   //fr Stopuhr
procedure TForm1.Timer3Timer(Sender: TObject);    //Timer3 im Objektinspektor auf False setzen
begin
  Label5.Caption:=FormatDateTime('hh:mm:ss:zz',Now-Merk);  //Std:Min:Sek:mSek
end;

procedure TForm1.Button6Click(Sender: TObject);  //einfache Stopuhr Start
begin
  // Label5.Caption := ' ';
   Merk:=Now;
   Timer3.Enabled:=True;
end;

procedure TForm1.Button7Click(Sender: TObject);  //einfache Stopuhr Stop
begin
  Timer3.Enabled:=False;
end;

end.

