unit Roem_zahlen;   //D.B. 10.2002  Dezimalzahlen in Roemische Zahlen

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormResize(Sender: TObject);

  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function DecimalToRoman (Decimal:longint):string;
const
  Romans: array [ 1..13 ] of string = ( 'I', 'IV', 'V',
   'IX', 'X', 'XL','L', 'XC', 'C', 'CD', 'D', 'CM', 'M' );

  Arabics: array [ 1..13 ] of integer = ( 1, 4, 5,
   9, 10, 40, 50, 90, 100, 400, 500, 900, 1000 );
var
  i: integer;
begin
  for i := 13 downto 1 do
  while (Decimal >= Arabics [i]) do
  begin
    Decimal := Decimal - Arabics [i];
    result  := result + Romans [i];
  end;
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
  if not (key in [#8, #9, #48 .. #57]) then key := #0;
end;

procedure TForm1.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  If (Key = VK_RETURN) Then 
  Begin
    If Edit1.Text < #0 Then
    ShowMessagePos('  Eingabe vergessen !',350,230)
  else
    Edit2.Text := DecimalToRoman(StrToInt(Edit1.Text));
  End;
  If (Key = VK_ESCAPE) Then
  Begin
    Edit1.clear;
    Edit2.clear;
  End;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  If Width > 520 Then Width := 520;
  If Height > 208 Then Height := 208;
end;

end.



