unit systemueberblick;               //04.2008 D.B.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,Registry, RXCtrls, LMDCustomComboBox, LMDDriveComboBox, WinSock,
  FileCtrl,mmsystem, RXShell, Menus, RxMenus;


type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    GroupBox3: TGroupBox;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    GroupBox4: TGroupBox;
    Label17: TLabel;
    Label18: TLabel;
    GroupBox5: TGroupBox;
    Label19: TLabel;
    Label20: TLabel;
    Button1: TButton;
    GroupBox6: TGroupBox;
    DriveComboBox1: TDriveComboBox;
    GroupBox7: TGroupBox;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    GroupBox8: TGroupBox;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    RxPopupMenu1: TRxPopupMenu;
    RxTrayIcon1: TRxTrayIcon;
    Ende1: TMenuItem;
    Ende2: TMenuItem;
    verbergen1: TMenuItem;
    Label38: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DriveComboBox1Change(Sender: TObject);
    procedure Label25Click(Sender: TObject);
    Procedure AppMiniMize(Sender : TObject);
    procedure RxTrayIcon1Click(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Ende2Click(Sender: TObject);
    procedure Ende1Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure verbergen1Click(Sender: TObject);
  
  private
    { Private-Deklarationen }
    function GetDisplayFrequency : Integer; //muss eingetragen werden fr Monitor Hz

  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


//******************* CPU: - ProcessorName aus Registry auslesen Ende **********
function GetProzessorName: string;
var reg: TRegistry;
begin
  result:='Unbekannter Prozessor';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\CentralProcessor\0', false);
    result:=reg.ReadString('ProcessorNameString');
  finally
    reg.free;
  end;
end;
//******************* CPU: - ProcessorName aus Registry auslesen Ende **********

//**************************** CPU: - Speed auslesen ***************************
function CalcCPUSpeed: Extended;
const
  DelayTime = 500; // measure time in ms
var
  TimerHi, TimerLo: DWord;
  PriorityClass, Priority: Integer;
begin
  try
    PriorityClass := GetPriorityClass(GetCurrentProcess);
    Priority := GetThreadPriority(GetCurrentThread);
    SetPriorityClass(GetCurrentProcess, REALTIME_PRIORITY_CLASS);
    SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_TIME_CRITICAL);
    Sleep(10);
    asm
      dw 310Fh // rdtsc
      mov TimerLo, eax
      mov TimerHi, edx
    end;
    Sleep(DelayTime);
    asm
      dw 310Fh // rdtsc
      sub eax, TimerLo
      sbb edx, TimerHi
      mov TimerLo, eax
      mov TimerHi, edx
    end;
    SetThreadPriority(GetCurrentThread, Priority);
    SetPriorityClass(GetCurrentProcess, PriorityClass);
    Result := TimerLo / (1000.0 * DelayTime);
  except
    Result := 0;
  end;
end;
//********************************* CPU: - Speed Ende **************************

//******************** Sonstiges: Win-Versionstype ermitteln *******************
{Die Unit SysUtils enthlt automatisch folgende globale Variablen:
 Win32MajorVersion, Win32MinorVersion, Win32Platform, Win32CSDVersion
 und Win32BuildNumber. Es mssen also keine Win32-API-Funktionen mehr
 aufgerufen werden. Nur die Zuordnung der Versionsnummern zu den
 Produktbezeichnungen ist noch ntig:
 uses SysUtils;        }
function GetWinVersion: string;
begin
  result:='Unbekannte Version';
  case Win32Platform of
    1: begin // 9x-Reihe
         if Win32MajorVersion=4 then begin
           if Win32MinorVersion=0 then result:='Windows 95'
           else if Win32MinorVersion=10 then result:='Windows 98'
           else if Win32MinorVersion=90 then result:='Windows Me';
         end;
       end;
    2: begin // NT-Reihe
         if (Win32MajorVersion=3) and (Win32MinorVersion=51) then result:='Windows NT 3.51'
         else if (Win32MajorVersion=4) and (Win32MinorVersion=0) then result:='Windows NT 4'
         else if Win32MajorVersion=5 then begin
           if Win32MinorVersion=0 then result:='Windows 2000'
           else if Win32MinorVersion=1 then result:='Windows XP'
           else if Win32MinorVersion=2 then result:='Windows .NET Server';
         end;
       end;
  end;
  //Win32CSDVersion enthlt Informationen zu Servicepacks
  if Win32CSDVersion<>'' then result:=result+' '+ Win32CSDVersion;
end;
//******************** Sonstiges: Win-Versionstype ermitteln Ende **************

//********************* Sonstiges: Windows NT erkennen *************************
//*Windows NT erkennen*
function isWindowsNT: Boolean;
var
  vi: TOSVersionInfo;
begin
  vi.dwOSVersionInfoSize := SizeOf(vi); GetVersionEx(vi);
  Result := vi.dwPlatformId = VER_PLATFORM_WIN32_NT;
end;
//********************* Sonstiges: Windows NT erkennen *************************

//*********** Grafik: Grafikkarte unter Xp aus Registrie auslesen **************
function GrafikkartenType: string;
var
  Reg : TRegistry;
begin
  GrafikkartenType := '';
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    if
    Reg.OpenKey('\System\ControlSet001\Control\Class\{4D36E968-E325-11CE-BFC1-08002BE10318}\0000',False) then
    GrafikkartenType := Reg.ReadString('DriverDesc');
  finally
    Reg.Free;
  end;
end;
//*********** Grafik: Grafikkarte unter Xp aus Registrie auslesen Ende *********

//****************** Bios - Datum Xp - aus Registrie auslesen ******************
function BiosDateXp: string;
var reg: TRegistry;
begin
  result:='Unbekannter Prozessor';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\', false);
    result:=reg.ReadString('SystemBiosDate');
  finally
    reg.free;
  end;
end;
//****************** Bios - Datum Xp - aus Registrie auslesen ******************

//****************** Video - Bios - Datum Xp - aus Registrie auslesen **********
function VideoBiosDateXp: string;
var reg: TRegistry;
begin
  result:='Unbekanntes Video - Bios - Datum';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\', false);
    result:=reg.ReadString('VideoBiosDate');
  finally
    reg.free;
  end;
end;
//************* Video - Bios - Datum Xp - aus Registrie auslesen Ende **********

//****************** Biosidentifizierung - aus Registrie auslesen **************
function Biosidentifizierung: string;
var
  Reg: TRegistry;
begin
  Biosidentifizierung := ' ';
  Reg := TRegistry.Create;
  try
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  if
  Reg.OpenKey('\Hardware\Description\System\MultifunctionAdapter\0',False) then
  Biosidentifizierung := Reg.ReadString('Identifier');
  finally
  Reg.Free;
  end;
end;
//****************** Biosidentifizierung - aus Registrie auslesen Ende *********

//****************** SystemBiosversion - aus Registrie auslesen **************
function Biosversion: string;
var
  Reg: TRegistry;
begin
  Biosversion := ' ';
  Reg := TRegistry.Create;
  try
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  if
  Reg.OpenKey('\Hardware\Description\System',False)
  then
  Biosversion := Reg.ReadString('SystemBiosVersion');
  finally
  Reg.Free;
  end;
end;
//****************** Biosidentifizierung - aus Registrie auslesen Ende *********

//##################### Partitionstyp der Lw auslesen ##########################
function GetHardDiskPartitionType(const DriveLetter:
         Char): string; // FAT  // NTFS
var
  NotUsed: DWORD;
  VolumeFlags: DWORD;
  VolumeInfo: array[0..MAX_PATH] of Char;
  VolumeSerialNumber: DWORD;
  PartitionType: array[0..32] of Char;
begin
  GetVolumeInformation(PChar(DriveLetter + ':\'),
    nil, SizeOf(VolumeInfo), @VolumeSerialNumber,NotUsed,
    VolumeFlags, PartitionType, 32);
  Result := PartitionType;
end;
//############################## Ende ##########################################

//##################### Label der Laufwerke auslesen ###########################
function GetPartitionName(const Dr: Char): String;
var
  tmp: Cardinal; //oder Integer (Delphi 3)
  buffer: array[0..19] of Char;
begin
  GetVolumeInformation(PChar(Dr+':\'),@buffer[0],SizeOf(buffer),nil,tmp,tmp,nil,0);
  Result := buffer;
end;

//################################# Ende #######################################

//********************* Seriennummer eines Laufwerkes herausfinden *************
//uses SysUtils
function GetHardDiskSerial(const Drive: char): string;
var
  NotUsed      : dWord;
  VolumeFlags  : dWord;
  VolumeInfo   : array[0..MAX_PATH] of char;
  VolumeSerialNumber: dWord;
begin
  GetVolumeInformation(PChar(Drive + ':\'), VolumeInfo, SizeOf(VolumeInfo),
               @VolumeSerialNumber, NotUsed, VolumeFlags, nil, 0);
  result := Format('%8.8X',               // Label = %s  VolSer = %8.8X
             [VolumeSerialNumber])        //[VolumeInfo, VolumeSerialNumber])
end;
//************************ Seriennummer eines Laufwerkes herausfinden **********

//**************************** Laufwerke: Laufwerke auslesen *******************
//******** Gre einer Festplatte/Diskette ermitteln & freien Speicher *********
//uses SysUtils;
function GetDiskSize(drive: Char; var free_size, total_size : Int64): Boolean;
var
  RootPath: array[0..26] of Char;
  RootPtr: PChar;
  current_dir: string;
begin
  RootPath[0] := Drive;
  RootPath[1] := ':';
  RootPath[2] := '\';
  RootPath[3] := #0;
  RootPtr := RootPath;
  current_dir := GetCurrentDir;
  if SetCurrentDir(Drive + ':\') then
  begin
    GetDiskFreeSpaceEx(RootPtr, Free_size, Total_size, nil);
    // this to turn back to original dir
    SetCurrentDir(current_dir);
    Result := True;
  end
 else
  begin
    Result := False;
    Free_size  := -1;
    Total_size := -1;
  end;
end;

procedure TForm1.DriveComboBox1Change(Sender: TObject);
var
  free_size, total_size: Int64;
begin
  if GetDiskSize(DriveComboBox1.Drive, free_size, total_size) then
  MessageDlg('   Laufwerk:  '+ Uppercase(DriveComboBox1.Drive) + ':\ ' +
  GetPartitionName(DriveComboBox1.Drive) + ^J + '   Partition:   ' +
  GetHardDiskPartitionType(DriveComboBox1.Drive)+^J +
  '   Serien Nr.  ' +GetHardDiskSerial(DriveComboBox1.Drive) +^J^J  +
  '   Grsse:   ' + FormatFloat('###,###,###'+ ' MB',total_size )+ ^J +
  '   Belegt:    ' + FormatFloat('###,###,###'+' MB', total_size - free_size ) + ^J +
  '   Frei:        ' + FormatFloat('###,###,###'+' MB', free_size ), mtInformation, [mbOK], 0)

{  ShowMessage('   Laufwerk:  '+ Uppercase(DriveComboBox1.Drive) + ':\ ' +
  GetPartitionName(DriveComboBox1.Drive) + ^J + '   Partition:   ' +
  GetHardDiskPartitionType(DriveComboBox1.Drive)+^J^J +
  '   Grsse:   ' + FormatFloat('###,###,###'+ ' MB',total_size )+ ^J +
  '   Frei:        ' + FormatFloat('###,###,###'+' MB', free_size )+ ^J +
  '   Belegt:    ' + FormatFloat('###,###,###'+' MB', total_size - free_size )) }
//  'Partitionstyp:  = GetHardDiskPartitionType(DriveComboBox1.Drive))
 else
  ShowMessage('keine Disk - CD/DVD im Laufwerk!');
end;
//##############################################################################

//******************************* IP - Auslesen ********************************
//uses WinSock
function GetIPAddress: string;
var
  phoste:PHostEnt;
  Buffer:array[0..100] of char;
  WSAData:TWSADATA;
begin
  result:=' ';
  if WSASTartup($0101, WSAData) <> 0 then exit;
  GetHostName(Buffer,Sizeof(Buffer));
  phoste:=GetHostByName(buffer);
  if phoste = nil then
begin
  result:='?.?.?.?';  //127.0.0.1
end
else
  result:=StrPas(inet_ntoa(PInAddr(phoste^.h_addr_list^)^));
  WSACleanup;
end;
//******************* Netz: - IP - eigene Adresse ermitteln Ende ***************

//********************* Sonstiges: - Computernamen ermitteln *******************
//uses SysUtils
function GetComputerName: String;
var
  Buffer: Array[0..MAX_COMPUTERNAME_LENGTH+1] of Char;
  Size: DWORD;
begin
  size:=1024;
  Windows.GetComputerName(Buffer, Size);
  Result:=StrPas(Buffer);
end;
//********************* Sonstiges: Computernamen ermitteln Ende ****************

//******* Aufruf1: Die IE - VersionsNr. auslesen *******************************
//Uses registry
function GetIEVersion(Key: string): string;
var
  Reg : TRegistry;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    Reg.OpenKey('Software\Microsoft\Internet Explorer',False);
    try
      Result := Reg.ReadString(Key);
    except
      Result := '';
    end;
    Reg.CloseKey;
  finally
    Reg.Free;
  end;
end;

//******* Aufruf1: Die IE - VersionsNr. auslesen Ende **************************

//************************* Grafik: Monitor Frequenz ***************************
//private
//function GetDisplayFrequency : Integer; //muss eingetragen werden.

function TForm1.GetDisplayFrequency: Integer;
const
  ENUM_CURRENT_SETTINGS  = DWORD(-1);
var
  DeviceMode: TDeviceMode;
begin
  if EnumDisplaySettings(nil, ENUM_CURRENT_SETTINGS, DeviceMode) then
    result := DeviceMode.dmDisplayFrequency
  else
    result := -1;
end;
//******************** Grafik: Monitor Frequenz Ende ***************************

//************************** CPU: - Prozessoren Anzahl *************************
function GetNumberOfProcessors: DWORD;
var
  SystemInfo: TSystemInfo;
begin
  GetSystemInfo(SystemInfo);
  Result := SystemInfo.dwNumberOfProcessors;
end;
//************************ CPU: Prozessoren Anzahl Ende ************************

//****************** Sonstiges: Windows ProductID aus Registrie ****************
//Uses registry
function ProductNr: string;
var
  Reg: TRegistry;
begin
  ProductNr := '';
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    if
    Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion',False) then
    ProductNr := Reg.ReadString('Productid');
  finally
    Reg.Free;
  end;
end;
//************** Sonstiges: Windows ProductID aus Registrie Ende ***************

//*********************** Windows Produktschlssel auslesen ********************
function GetWinProductKey: string;
const
  Digits = 'BCDFGHJKMPQRTVWXY2346789';
var
  Reg: TRegistry;
  Value: String;
  i,j,x: Integer;
begin
  Result := '';
  Reg := TRegistry.Create(KEY_READ);
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    Reg.OpenKey('SOFTWARE\Microsoft\Windows NT\CurrentVersion', False);
    SetLength(Value, Reg.GetDataSize('DigitalProductID'));
    if (Length(Value) >= 67) then
    begin
      Reg.ReadBinaryData ('DigitalProductID', Value[1], Length (Value));
      for i := 24 downto 0 do
      begin
        x := 0;
        for j := 14 downto 0 do
        begin
          x := (x shl 8) + Ord(Value[53+j]);
          Value[53+j] := Char(x div 24);
          x := x mod 24;
        end;
        Result := Digits[x+1] + Result;
        if ( (i > 0) and ((i mod 5) = 0) ) then
          Result := '-' + Result;
      end;
    end;
  finally
    Reg.Free;
  end;
end;
//*********************** Windows Produktschlssel auslesen ********************

//************************************ Maus ************************************
// wenn result 0 zurckgibt, ist keine Maus angeschlossen.

function GetNumberOfMouseButtons : integer;
begin
  result := GetSysTemMetrics(SM_CMOUSEBUTTONS);
end;

//ShowMessage(' '+inttostr(GetNumberOfMouseButtons)+' buttons.');
//*********************************** Maus Ende ********************************

//***************** Soundkarte: SoundkartenType aus Registrie ******************
//Uses registry
function SoundkartenType: string;
var
  Reg : TRegistry;
begin
  SoundkartenType := '';
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    if
    Reg.OpenKey('\System\CurrentControlSet001\Enum\PCI\VEN_10DE&DEV_00EA&SUBSYS_A0021458&REV_A1\{3&13c0b0c5&0&30}\0000',False) then
    SoundkartenType := Reg.ReadString('Class');
  finally
    Reg.Free;
  end;
end;
//*************** Soundkarte: SoundkartenType aus Registrie Ende ***************

//************************ CPU: - Name aus Registry auslesen *******************
//Uses registry
function CPUname: string;
var
  Reg: TRegistry;
begin
  CPUname := '';
  Reg := TRegistry.Create;
  try
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  if
  Reg.OpenKey('\Hardware\Description\System\CentralProcessor\0',False) then
  CPUname := Reg.ReadString('Identifier');
  finally
  Reg.Free;
  end;
end;
//******************* CPU: - Name aus Registry auslesen Ende *******************

//*********** //Lizenzierungsinformationen von Windows anzeigen ****************
procedure GetOwnerAndCompanyName(var sOwner,sOrganization: string);
var
  reg: TRegistry;
  vi: TOSVersionInfo;
  sWindows: string;
begin
  reg      := TRegistry.Create;
  sWindows := '\Windows\';
  try
    vi.dwOSVersionInfoSize := SizeOf(vi);
    getversionex(vi);
    reg.RootKey := HKEY_LOCAL_MACHINE;
    if (vi.dwPlatformId = VER_PLATFORM_WIN32_NT) then
    sWindows := '\Windows NT\';
    if reg.OpenKey('Software\Microsoft' + sWindows + 'CurrentVersion', False) then
    begin
      // Name
      sOwner := reg.ReadString('RegisteredOwner');
      // Organization
      sOrganization :=
reg.ReadString('RegisteredOrganization');
    end;
  finally
    reg.Free;
  end;
end;
//*********** //Lizenzierungsinformationen von Windows anzeigen ****************

//**************** Windows Installdatum aus Registry lesen *********************
 function GetWindowsInstallDateTime: TDateTime;
const
  RegKeyNT = 'SOFTWARE\Microsoft\Windows NT\CurrentVersion';
  RegValNT = 'InstallDate';
  RegKey95 = 'SOFTWARE\Microsoft\Windows\CurrentVersion';
  RegVal95 = 'FirstInstallDateTime';
  function RegReadDWORD(const Key, Name: string): DWORD;
  begin
    Result := 0;
    with TRegistry.Create do
      try
        RootKey := HKEY_LOCAL_MACHINE;
        if KeyExists(Key) and OpenKeyReadOnly(Key) and ValueExists(Name) and
          (GetDataType(Name) in [rdInteger, rdBinary, rdUnknown]) and
          (GetDataSize(Name) = SizeOf(Result)) then
          if GetDataType(Name) = rdInteger then
            Result := DWORD(ReadInteger(Name))
          else
            ReadBinaryData(Name, Result, SizeOf(Result));
      finally
        Free;
      end;
  end;
var
  Value: DWORD;
begin
  Value := RegReadDWORD(RegKeyNT, RegValNT);
  if Value <> 0 then
    Result := EncodeDate(1970, 1, 1) + (Value / SecsPerDay)
  else
  begin
    Value := RegReadDWORD(RegKey95, RegVal95);
    if Value <> 0 then
      Result := FileDateToDateTime(Value)
    else
      Result := 0.0;
  end;
end;

////////////////////////////////////////////////////////////////////////////////
// Beispiel

{
procedure TForm1.Button1Click(Sender: TObject);
begin
   ShowMessage(FormatDateTime('yyyy-mm-dd hh:nn:ss', GetWindowsInstallDateTime));
end;

end.     }



//##############################################################################
 function GetWinInstallDateTime: TDateTime;
        function isWindowsNT: Boolean;
        var
          vi: TOSVersionInfo;
        begin
          vi.dwOSVersionInfoSize := SizeOf(vi);
          GetVersionEx(vi);
          Result := vi.dwPlatformId = VER_PLATFORM_WIN32_NT;
        end;
        function UnixDateTimeToDateTime(UnixDateTime: Longint): TDateTime;
        begin
          Result := EncodeDate(1970, 1, 1) + (UnixDateTime / SecsPerDay);
        end;
      var
        i: LongInt;
      begin
        Result := -1;
        with TRegistry.Create do
          try
            RootKey := HKEY_LOCAL_MACHINE;
            if isWindowsNT then
            begin
              if OpenKeyReadOnly('\SOFTWARE\Microsoft\WindowsNT\CurrentVersion') then
                try
                  Result := UnixDateTimeToDateTime(ReadInteger('InstallDate'));
                finally
                  CloseKey;
                end;
            end
            else
            begin
              if OpenKeyReadOnly('\SOFTWARE\Microsoft\Windows\CurrentVersion')
      then
                try
                  ReadBinaryData('FirstInstallDateTime', i, SizeOf(i));
                  Result := FileDateToDateTime(i);
                finally
                  CloseKey;
                end;
            end;
          finally
            Free;
          end;
      end;
//**************** Windows Installdatum aus Registry lesen *********************

//***************************** Windowa - Version ermitteln ********************
//uses registry;
function GetWindowsVersion: string;
var
  VerInfo: TOsversionInfo;
  PlatformId, VersionNumber: string;
  Reg: TRegistry;
begin
  VerInfo.dwOSVersionInfoSize := SizeOf(VerInfo);
  GetVersionEx(VerInfo);
  // Detect platform
  Reg := TRegistry.Create;
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  case VerInfo.dwPlatformId of
    VER_PLATFORM_WIN32s:
      begin
        // Registry (Huh? What registry?)
        PlatformId := 'Windows 3.1';
      end;
    VER_PLATFORM_WIN32_WINDOWS:
      begin
        // Registry
        Reg.OpenKey('\SOFTWARE\Microsoft\Windows\CurrentVersion', False);
        PlatformId    := Reg.ReadString('ProductName');
        VersionNumber := Reg.ReadString('VersionNumber');
      end;
    VER_PLATFORM_WIN32_NT:
      begin
        // Registry
        Reg.OpenKey('\SOFTWARE\Microsoft\Windows NT\CurrentVersion', False);
        PlatformId    := Reg.ReadString('ProductName');
        VersionNumber := Reg.ReadString('CurrentVersion');
      end;
  end;
  Reg.Free;
  Result := PlatformId + '    (version: ' + VersionNumber + ')';
end;
//***************************** Windowa - Version ermitteln ********************

//************************** Form Create ***************************************
procedure TForm1.FormCreate(Sender: TObject);
Var
  sOwner, sOrganization: string;   //Lizenzierungsinformationen von Windows anzeigen
  SizeX,SizeY  : Integer;  //aktuelle Auflsung
//  SysInfo: TSystemInfo; //fr CPU - Information
  MS : TMemoryStatus;//fr Speicherauslesung, SWP-Auslesung,
  B,P,G  : LongInt;  //(B = Belegt fr Swp) & (P & G = fr % belegter Speicher)
  DesktopDC    : HDC;                           //fr Farbtiefe
  BitsPerPixel : integer;                       //fr Farbtiefe
  Buffer: Array[0..MAX_PATH+1] of Char;         //Den User-Namen bestimmen
  Size: DWORD;                                  //Den User-Namen bestimmen

begin
   Application.OnMiniMize := AppMiniMize;//Minimiert starten(& Icon nur bei Uhr)
   Form1.WindowState := wsMinimized;     // Form1 kreieren und gleich verstecken
   RxTrayIcon1.Hint := ' Was steckt alles in diesem PC '+ #10#13 + '   Copyright:  by D.Bttner.';

   size:=1024;                                  //Den User-Namen bestimmen
   GetUserName(Buffer, Size);                                             //Den User-Namen bestimmen
 //Prozessor
  Label1.Caption := 'Type:               ' + GetProzessorName;
  //CPU - Speed
  Label2.Caption:= 'Speed:            '+ FormatFloat(''+'###,#' + ' MHz', CalcCPUSpeed );
  //Win-versionstype ermitteln
  Label17.Caption := GetWinVersion;
  //NT - 9x version
begin
  if isWindowsNT then
    Label18.caption :='Window:   NT - Version'
  else
    Label18.caption :='Window:   9x - Version';
end;

  MS.dwLength := SizeOf(TMemoryStatus);         // Fr SpeicherStatus
  GlobalMemoryStatus(MS);                       // Fr SpeicherStatus & Swp Datei
  SizeX := Screen.Width;                        // fr Auflsung Weite
  SizeY := Screen.Height;                       // fr Auflsung Hhe
//************************** GrafikkartenType **********************************
 Label11.Caption:= 'Grafikkarte: ' +  '              ' + GrafikkartenType;
//************************** GrafikkartenType **********************************
//aktuelle Auflsung
  Label12.Caption:= 'aktuelle Auflsung:   ' + IntToStr(SizeX) + '  X  ' +
                                               IntToStr(SizeY);
//******************************************************************************
//******************************************************************************
//Bios - Datum Xp
  Label19.Caption:= ' Bios - Datum:           '+ BiosDateXp;
//******************************************************************************
//******************************************************************************
//Bios - Version Xp
  Label20.Caption:= ' Video-Bios-Datum:    '+ VideoBiosDateXp;
//******************************************************************************

//******************************************************************************
//Bios - Identifizierung Xp
  Label28.Caption:= ' Identifizierung:    '+ '     ' + BiosIdentifizierung;
//******************************************************************************

//******************************************************************************
//Bios - Identifizierung Xp
  Label29.Caption:= ' Biosversion:    '+ '     '; //+ Biosversion;
//******************************************************************************

//******************************************************************************
//Speicher Total & Speicher Frei
  Label5.Caption :=
  FormatFloat('Speicher Total:     '+'###,###'+' MB', MS.dwTotalPhys Div 1024
  DIV 1020 );//TotalSpeicher
//  Label21.Hint := FormatFloat('Speicher gesamt: '+'###'+
//  ' MB ', MS.dwTotalPhys DIV 1024 Div 1020 );   // Fr Hintanzeige in Megabyte
//******************************************************************************

//******************************************************************************
  Label6.Caption :=
  FormatFloat('Speicher belegt:      '+'###,###'+' MB', MS.dwTotalPhys Div 1024
  DIV 1020 - MS.dwAvailPhys Div 1024 DIV 1020 );//Totalbelegt
//******************************************************************************

//******************************************************************************
  Label7.Caption :=
  FormatFloat('Speicher Frei:       '+'###,###'+' MB', MS.dwAvailPhys Div 1024
  DIV 1020 );//TotalFrei
//  Label22.Hint := FormatFloat('Speicher frei: '+'###'+
//  ' MB ', MS.dwAvailPhys DIV 1024 Div 1020 );   // Fr Hintanzeige in Megabyte
//******************************************************************************

//******************************************************************************
//Speicheranzeige in %
  P := MS.dwTotalPhys Div 100;          // 1% von Speicher Total
  G := MS.dwTotalPhys - MS.dwAvailPhys ;//Speicher Total - Speicher Frei = Belegt
  Label8.Caption := FormatFloat('Speicherauslastung:   '+'###,##'+' % ' ,G Div P);
//  Label24.Hint := FormatFloat('###,##'+' % vom Speicher sind belegt' ,G Div P );
//******************************************************************************

//******************************************************************************
//Gre der Auslagerungsdatei
  B := Ms.dwTotalPageFile Div 1024 - Ms.dwAvailPageFile Div 1024;
  Label9.Caption:=FormatFloat('Auslagerungsdatei:     '+'###,###' + ' MB ', + B Div 1024);
//  Label25.Hint := ' Anforderung an ' + #10#13 +' die Swp-Datei ';
//******************************************************************************

//************************** Farbtiefe ermitteln *******************************
begin
  DesktopDC := GetDC(0);//DeviceContext des Desktops und ermittelt dessen Farbtiefe:
  BitsPerPixel := GetDeviceCaps(DesktopDC, BITSPIXEL);
  case BitsPerPixel of
    4: Label13.Caption := 'aktuelle Farbtiefe:     16 Farben 4-Bit ';
    8: Label13.Caption := 'aktuelle Farbtiefe:     256 Farben 8-Bit';
    16:Label13.Caption := 'aktuelle Farbtiefe:     64K Farben 16-Bit';
    24:Label13.Caption := 'aktuelle Farbtiefe:     16M Farben 24-Bit';
    32:Label13.Caption := 'aktuelle Farbtiefe:     True Color 32-Bit';
  end;
  ReleaseDC(0, DesktopDC);
end;
//************************** Farbtiefe ermitteln Ende **************************

//******************************************************************************
//Die eigene IP auslesen
  Label21.Caption:= 'Netzwerk - IP:           '+ GetIPAddress;
//******************************************************************************

//Aufruf - Beispiel
//******************************************************************************
//Computernamen ermitteln
  Label22.Caption:= 'Computername:         ' + GetComputerName;
//******************************************************************************

{  ShowMessage('IE-Version: ' +
  GetIEVersion('Version')[1] + '.' +
  GetIEVersion('Version')[3]);
  ShowMessage('IE-Version: ' + GetIEVersion('Version'));   }
 Label23.Caption:= 'Internet Explorer - Version:    ' + GetIEVersion('Version');

 //******************************************************************************
//private
//function GetDisplayFrequency : Integer; //muss in private eingetragen werden.
  Label14.Caption := 'Monitorfrequenz:       '+ IntToStr(GetDisplayFrequency)+' Hz';
//******************************************************************************
//Username
  Label24.Caption := 'Anwender - Name:    ' + StrPas(Buffer);
//******************************************************************************

//******************************************************************************
//CPU - Anzahl
  Label3.Caption:= 'Prozessoren:   '+ IntToStr(GetNumberOfProcessors)+' Stck';
//******************************************************************************

//******************************************************************************
//Windows ProductNr
  Label32.Caption :='Windows ProductNr:                              '   + ProductNr;
//******************************************************************************

//**************************** Windows Registrierschlssen *********************
 Label33.caption := 'Window - Produktschlssel              ' + GetWinProductKey;
//**************************** Windows Registrierschlssen *********************

//******************************************************************************
//SoundkartenType
  Label25.Caption := ' Soundkartentyp:  bei Klick              ';

//******************************************************************************
//CPU - Name
  Label4.Caption:= 'Name:              ' + CPUname;
//******************************************************************************

//*********** //Lizenzierungsinformationen von Windows anzeigen ****************
   GetOwnerAndCompanyName(sOwner, sOrganization);
   Label34.caption := 'Benutzer:     ' + sOwner;         //Besitzer - Benutzer
   Label35.caption := 'Organisation:      ' + sOrganization; //Organisation
//*********** //Lizenzierungsinformationen von Windows anzeigen ****************

//******************************************************************************
       // ShowMessage(FormatDateTime('dd.mm.yy', GetWinInstallDateTime));
///Label36.caption := 'Installiert am  ' + FormatDateTime('dd.mm.yy', GetWinInstallDateTime);

Label36.caption := 'Installiert am ' + FormatDateTime('dd.mm.yyyy  hh:nn:ss', GetWindowsInstallDateTime);
//******************************************************************************

//***************************** Windowa - Version ermitteln ********************
  Label37.Caption := GetWindowsVersion;
//***************************** Windowa - Version ermitteln ********************



//************************** Form Create Ende **********************************
end;

//******************************************************************************
Procedure TForm1.AppMiniMize(Sender : TObject);// Hide on Minimize
Begin
  ShowWindow(Application.Handle, SW_Hide);//Programmanzeige in der Taskleiste verstecken
 //ShowWindow(Application.Handle,SW_Minimize);
End;
//******************************************************************************

procedure TForm1.Button1Click(Sender: TObject);   //verstecken-button auf Form1
begin
  Form1.hide;
end;

procedure TForm1.Label25Click(Sender: TObject);
begin
  WinExec('rundll32.exe shell32.dll,Control_RunDLL mmsys.cpl,,2',SW_SHOWNORMAL);
end;

procedure TForm1.RxTrayIcon1Click(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
  var x1,y1,x2,y2 : Integer;       //Variablen fr Mousezeiger
begin
  x1 := 400;                       // x1 Initialisieren - Mouse_Event
  y1 := 260;                       // y1 Initialisieren - Mouse_Event
  x2 := mouse.cursorpos.x;         // XPos von Maus auf Trayicon vor dem drcken
  y2 := mouse.cursorpos.y;         // YPos von Maus auf Trayicon vor dem drcken
  Form1.WindowState := wsnormal;
  Form1.Visible := Not Form1.Visible;
  Mouse.CursorPos := Point(400,260);// Mousezeiger X-Achse(440) Y(360)auf Form1 setzen
  Mouse_Event(MouseEventF_leftDown,x1,y1,0,0); //Mousetaste wurde runtergedrckt
  Mouse_Event(MouseEventF_leftUp,x1,y1,0,0);   //Mousetaste wurde losgelassen
//Wenn Mouse_Event beendet & Form1 Focus hat, Cursor auf Trayiconbutton setzen
  Mouse.CursorPos := Point(x2,y2);//CursorPos auf Trayicon in Taskl. setzen (alte Pos)
end;

//####################### Kontexmenue ##########################################
procedure TForm1.Ende2Click(Sender: TObject);   //Popupmenue - Ende (Programmende)
begin
  Form1.close;
end;

procedure TForm1.Ende1Click(Sender: TObject);   //Popupmenue - zeigen
begin
  Form1.show;
end;

procedure TForm1.verbergen1Click(Sender: TObject);  //Popupmenue - verbergen
begin
  Form1.Hide;
end;
//######################### Kontexmenue ende ###################################

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  If(Key = #27)Then Form1.Hide;    //mit Esc Taste verstecken
//  If (Key = #73) Then MessageDlg('Druckauftrag abgebrochen', mtInformation, [mbOK],0);//Info Alt+I
end;

//************************ OnKeyDown fr Sondertasten **************************
procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  If (Key = VK_ESCAPE) Then Form1.Hide;
//  If (Key = VK_F1) Then Hilfe;     //F1 = Info
  If ((Shift = [ssAlt]) And (Key = 73)) Then MessageDlg('Sie haben Taste Alt && Taste I gedrckt', mtInformation, [mbOK],0);//Info Alt+I
//  If (Key = VK_F3) Then Suchen1Click(Self);     //RxSpeedButton1 = Suchen F3
//  If ((Shift = [ssAlt]) And (Key = 83)) Then Suchen1Click(Self);//Suchen Alt+S
//  If ((Shift = [ssAlt]) And (Key = 66)) Then Beenden1Click(Self);//Prog beenden Alt+B
//  If ((Shift = [ssAlt]) And (Key = 86)) Then Anzeigen1Click(Self);//Verbergen Alt+V
  If (Key = VK_F10) Then Form1.Close;      //Prog ber F10 beenden
end;
//************************ OnKeyDown fr Sondertasten **************************




end.

