unit Unit1; //CD-DVD - AutoPlay aktivieren - deaktivieren  D.B.  30.10.2013

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, registry, ExtCtrls, Buttons, Grids;

type
  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormResize(Sender: TObject);

  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

//################### Reg_SZ - Wert aus Registry lesen #########################
function ReadFromReg(ValueName : string): string;
var Registry : TRegistry;
 begin
   Registry := TRegistry.Create;
   Result := '';
   try
     Registry.RootKey := HKEY_LOCAL_MACHINE;
     if Registry.KeyExists ('Software\Classes\AudioCD\') then
     if Registry.OpenKey ('Software\Classes\AudioCD\Shell\', False) then
     Result := Registry.ReadString(ValueName);
   finally
     Registry.Free;
   end;
 end;
//#################### Reg_SZ - Wert aus Registry lesen Ende ###################

//############################ In Registry schreiben ###########################
procedure CDSetAutoPlay (SioNo: Boolean);
var
  Reg : TRegistry;
begin
  try
    Reg := TRegistry.Create;
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    if Reg.KeyExists ('Software\Classes\AudioCD\') then
    if Reg.OpenKey ('Software\Classes\AudioCD\Shell\', False) then
    if SioNo then Reg.WriteString('', 'play')
    else
     Reg.WriteString('', '');
  finally
    Reg.Free;
  end;
end;
//############################ In Registry schreiben Ende ######################

procedure TForm1.FormCreate(Sender: TObject);
var
  CLFRgn: HRgn;   //fr Form1 - mit abgerundeten Ecken
  reg: TRegistry; //fr Form1 - mit abgerundeten Ecken
  Key : String;   //fr Registry - Schlsselabfrage
begin
//  CLFRgn := CreateRoundRectRgn(0,0,Form1.Width,Form1.Height,20,20);  //wenn Form1 - abgerundete Ecken haben soll
//  SetWindowRgn(Form1.Handle,CLFRgn,True);                            //wenn Form1 - abgerundete Ecken haben soll

//  Label1.caption := ReadFromReg(Key);       //Ausgabe der Abfrage, ob CD/DVD-Autoplay on/off ist, in einem Label

  if ReadFromReg(Key) = 'play' Then     //Abfrage des Schlssels, wenn play drin steht
  begin
    BitBtn1.Caption := 'Autoplay' + #13#10 + 'ist' + #13#10 + ' aktiviert';
    BitBtn2.Caption := 'Autoplay' + #13#10 + ' deaktiviert';
    BitBtn1.Font.Color := clgreen;
    BitBtn2.Font.Color := clWindowText;
  end
else
  begin
    BitBtn2.Caption := 'Autoplay' + #13#10 + 'ist' + #13#10 + ' deaktiviert';
    BitBtn1.Caption := 'Autoplay' + #13#10 + ' aktiviert';
    BitBtn2.Font.Color := clred;
    BitBtn1.Font.Color := clWindowText;
  end;
end;

//############################# Autoplay on  auslsen ##########################
procedure TForm1.BitBtn1Click(Sender: TObject);
var
  i: Integer;                                                    //fr BitBtn1 MULTILINE
begin
  i := GetWindowLong(BitBtn1.Handle, GWL_STYLE);                 //fr BitBtn1 MULTILINE
  SetWindowLong(BitBtn1.Handle, GWL_STYLE, i or BS_MULTILINE);   //fr BitBtn1 MULTILINE
  BitBtn1.Caption := 'Autoplay' + #13#10 + 'wurde' + #13#10 + ' aktiviert';
  BitBtn1.Font.Color := clgreen;
  BitBtn2.Caption := 'Autoplay' + #13#10 + ' deaktiviert';
  BitBtn2.Font.Color := clWindowText;
  CDSetAutoPlay(True);
// MessageDlg('Autoplay wurde aktiviert', mtInformation, [mbOK], 0);
end;
//############################# Autoplay on  auslsen Ende #####################

//######################### Autoplay off  auslsen #############################
procedure TForm1.BitBtn2Click(Sender: TObject);
var
  i: Integer;                                                    //fr BitBtn2 MULTILINE
begin
  i := GetWindowLong(BitBtn2.Handle, GWL_STYLE);                 //fr BitBtn2 MULTILINE
  SetWindowLong(BitBtn2.Handle, GWL_STYLE, i or BS_MULTILINE);   //fr BitBtn2 MULTILINE
  BitBtn2.Caption := 'Autoplay' + #13#10 + 'wurde' + #13#10 + ' deaktiviert';
  BitBtn2.Font.Color := clred;
  BitBtn1.Caption := 'Autoplay' + #13#10 + ' aktiviert';
  BitBtn1.Font.Color := clWindowText;
  CDSetAutoPlay(false);
// MessageDlg('Autoplay wurde deaktiviert', mtInformation, [mbOK], 0);
end;
//######################### Autoplay off  auslsen Ende ########################

//######################## Form1 - Grsse begrenzen ############################
procedure TForm1.FormResize(Sender: TObject);
begin
  If Width <> 294 Then Width := 294;
  If Height <> 105 Then Height := 105;
end;
//######################## Form1 - Grsse begrenzen Ende #######################

end.
