unit Unit1;  //D.B. 01.2014 Exe unter Win7 in Admin starten sonst unter Umstnden keine Korrekte Anzeige

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Registry, Math, StdCtrls, ExtCtrls, FileCtrl, CWMIBase,
  COperatingSystemInfo, ActiveX, WbemScripting_TLB, ShellAPI;

//fr Key Auslesung 32 & 64 Bit ################################################
function IS_WinVerMin2K: BOOLEAN;
  function View_Win_Key: String;
  function DecodeProductKey(Const HexSrc: Array Of Byte): String;
  function DecodeWin8(Const HexSrc: Array Of Byte): String;
  function IsWow64: Boolean;
  function BinToInt(Value: String): Integer;
//fr Key Auslesung 32 & 64 Bit ################################################

  function Sprache: string;

//fr Key Auslesung 32 & 64 Bit ################################################
var
  Reg: TRegistry;
  binarySize: Integer; 
  HexBuf: Array Of Byte;
  temp: TStringlist;
  KeyName, KeyName2, SubKeyName, BuLab,CurBuNr, PN, PID, DN: String;

Const 
  KEY_WOW64_64KEY = $0100;
  KEY_WOW64_32KEY = $0200;
//fr Key Auslesung 32 & 64 Bit ################################################

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Button1: TButton;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    ComboBox1: TComboBox;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    DriveComboBox1: TDriveComboBox;
    Label38: TLabel;
    Label39: TLabel;
    Timer1: TTimer;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    Label45: TLabel;
    Label46: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DriveComboBox1Change(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);

  private
    { Private-Deklarationen }

  public
    { Public-Deklarationen }

  end;

//fr Speicherermittlung########################################################
type
  TMemoryStatusEx = packed record
    dwLength: DWORD;
    dwMemoryLoad: DWORD;
    ullTotalPhys: Int64;
    ullAvailPhys: Int64;
    ullTotalPageFile: Int64;
    ullAvailPageFile: Int64;
    ullTotalVirtual: Int64;
    ullAvailVirtual: Int64;
    ullAvailExtendedVirtual: Int64;
  end;
//fr Speicherermittlung########################################################

var
  Form1: TForm1;
   aLoc: ISWbemLocator;     //fr Grafikkartenspeicher auslesen
   aSrv: ISWbemServices;    //fr Grafikkartenspeicher auslesen
   aObjSet: ISWbemObjectSet;//fr Grafikkartenspeicher auslesen
   pEnum: IEnumVARIANT;     //fr Grafikkartenspeicher auslesen
   vOut: OleVariant;        //fr Grafikkartenspeicher auslesen
   dwRetrieved: LongWord;   //fr Grafikkartenspeicher auslesen
   hRes: HResult;           //fr Grafikkartenspeicher auslesen
   cWQL, sWQL: string;      //fr Grafikkartenspeicher auslesen
   st: TStringList;         //fr Grafikkartenspeicher auslesen


implementation

{$R *.dfm}

//fr Speicherermittlung########################################################
function GlobalMemoryStatusEx(var lpBuffer: TMemoryStatusEx): BOOL; stdcall; external kernel32;
//fr Speicherermittlung########################################################

//****************** Bios - Datum  - aus Registrie auslesen ******************
function BiosDateXp: string;
var reg: TRegistry;
begin
  result:='Unbekannter Prozessor';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\', false);
    result:=reg.ReadString('SystemBiosDate');
  finally
    reg.free;
  end;
end;
//****************** Bios - Datum  - aus Registrie auslesen ******************

//****************** Video - Bios - Datum  - aus Registrie auslesen **********
function VideoBiosDateXp: string;
var reg: TRegistry;
begin
  result:='Unbekanntes Video - Bios - Datum';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\', false);
    result:=reg.ReadString('VideoBiosDate');
  finally
    reg.free;
  end;
end;
//************* Video - Bios - Datum  - aus Registrie auslesen Ende **********

//****************** Biosidentifizierung - aus Registrie auslesen **************
function Biosidentifizierung: string;
var
  Reg: TRegistry;
begin
  Biosidentifizierung := ' ';
  Reg := TRegistry.Create;
  try
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  if
  Reg.OpenKey('\Hardware\Description\System\MultifunctionAdapter\0',False) then
  Biosidentifizierung := Reg.ReadString('Identifier');
  finally
  Reg.Free;
  end;
end;
//****************** Biosidentifizierung - aus Registrie auslesen Ende *********

//****************** SystemBiosversion - aus Registrie auslesen ****************
function Biosversion: string;
var
  Reg: TRegistry;
begin
  Biosversion := ' ';
  Reg := TRegistry.Create;
  try
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  if
  Reg.OpenKey('\Hardware\Description\System',False)
  then
  Biosversion := Reg.ReadString('SystemBiosDate');
  finally
  Reg.Free;
  end;
end;
//****************** Biosidentifizierung - aus Registrie auslesen Ende *********

//cpu
function GetBioshersteller: string;
var reg: TRegistry;
begin
  result:='Unbekannter Hersteller';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\CentralProcessor\0', false);
    result:=reg.ReadString('VendorIdentifier');
  finally
    reg.free;
  end;
end;

//cpu
function GetProzessorName: string;
var reg: TRegistry;
begin
  result:='Unbekannter Prozessor';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\CentralProcessor\0', false);
    result:=reg.ReadString('ProcessorNameString');
  finally
    reg.free;
  end;
end;

//cpu
function GetCpuSpeed: string;
var
   Reg: TRegistry;
begin
   Reg := TRegistry.Create;
   try
     Reg.RootKey := HKEY_LOCAL_MACHINE;
     if Reg.OpenKey('Hardware\Description\System\CentralProcessor\0', False) then
     begin
       Result := IntToStr(Reg.ReadInteger('~MHz')) + ' MHz';
       Reg.CloseKey;
     end;
   finally
     Reg.Free;
   end;
end;

//cpu
function GetIdentifier: string;
var reg: TRegistry;
begin
  result:='Identifizierung Unbekannt';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\CentralProcessor\0', false);
    result:=reg.ReadString('Identifier');
  finally
    reg.free;
  end;
end;

//cpu
function GetCPUCnt(): Cardinal;  //Anzahl der CPU KERNE rausfinden
 asm
   mov eax, fs: [$30]
   mov eax, [eax+$64]
 end;
//*****************************************************************************
//Mainboard
function GetBordBiosversion: string;
var reg: TRegistry;
begin
  result:='Unbekannter Version';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\Bios\', false);
    result:=reg.ReadString('Biosversion');
  finally
    reg.free;
  end;
end;

//Mainboard
function GetBordBiosdatum: string;
var reg: TRegistry;
begin
  result:='Unbekannter Datum';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\Bios\', false);
    result:=reg.ReadString('Biosreleasedate');
  finally
    reg.free;
  end;
end; 

//Mainboard
function GetBordhersteller: string;
var reg: TRegistry;
begin
  result:='Unbekannter Hersteller';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\Bios\', false);
    result:=reg.ReadString('BaseBoardManufacturer');
  finally
    reg.free;
  end;
end;

//Mainboard
function GetBordserie: string;
var reg: TRegistry;
begin
  result:='Unbekannter Serie';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\Bios\', false);
    result:=reg.ReadString('BaseBoardProduct');
  finally
    reg.free;
  end;
end;

//Mainboard
function BiosVendor: string;
var reg: TRegistry;
begin
  result:='Unbekannter Hersteller';
  reg:=TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('Hardware\Description\System\Bios\', false);
    result:=reg.ReadString('BiosVendor');
  finally
    reg.free;
  end;
end;
//*****************************************************************************

//************************ Systemsprache ermitteln ****************************
function Sprache: string;
var
  ID: word; 
  p: Pchar; 
begin 
  getmem(p, 256); 
  ID := GetSystemDefaultLangID;
  VerLanguageName(ID, p, 256); 
  result := p; 
  freemem(p);
end;
//************************ Systemsprache ermitteln Ende ************************

//fr Key Auslesung 32 & 64 Bit ################################################
function IS_WinVerMin2K: BOOLEAN;
var
  OS: ToSVersionInfo;
begin
  ZeroMemory(@OS, SizeOf(OS));
  OS.dwOSVersionInfoSize := SizeOf(OS);
  GetVersionEx(OS);
  Result := (OS.dwMajorVersion >= 5) and
            (OS.dwPlatformId = VER_PLATforM_WIN32_NT);
  PN := '';
  PID := '';
end;

function IsWow64: Boolean;
type
  TIsWow64Process = function(Handle: Windows.THandle; var Res: Windows.BOOL): Windows.BOOL; stdcall;
var 
  IsWow64Result: Windows.BOOL;
  IsWow64Process: TIsWow64Process;
begin
  IsWow64Process := Windows.GetProcAddress(Windows.GetModuleHandle('kernel32'), 'IsWow64Process');
  if Assigned(IsWow64Process) then
    begin
      if not IsWow64Process(Windows.GetCurrentProcess, IsWow64Result) then
        raise SysUtils.Exception.Create('IsWow64: bad process handle');
      Result := IsWow64Result;
    end
  else
    Result := False;
end;

function View_Win_Key: String;    //32 bit Zweig
begin
  if IsWow64 = false then
    begin
      with TRegistry.Create do
        begin
          try
            RootKey := HKEY_LOCAL_MACHINE;
            if OpenKey('\SOFTWARE\Microsoft\Windows NT\CurrentVersion', false) then
              begin
                if GetDataType('DigitalProductId') = rdBinary then
                  begin
                    PN := (ReadString('ProductName')) + ' 32 bit';;
                    PID := (ReadString('ProductID'));
                    BuLab := (ReadString('BuildLab'));
                    CurBuNr := (ReadString('CurrentBuildNumber'));
                    binarySize := GetDataSize('DigitalProductId');
                    SetLength(HexBuf, binarySize);
                    if binarySize > 0 then
                      begin
                        ReadBinaryData('DigitalProductId', HexBuf[0], binarySize);
                      end;
                  end;
                CloseKey;
              end;
          finally
            free;
          end;
            Result := '';
              if pos('8',PN) > 0 then
                Result := DecodeWin8(HexBuf)
              else
                Result := DecodeProductKey(HexBuf);
        end;
    end;
  if IsWow64 then         //64 bit Zweig
    begin
      with TRegistry.Create(KEY_ALL_ACCESS OR KEY_WOW64_64KEY) do
        begin
          try
            RootKey := HKEY_LOCAL_MACHINE;
            if OpenKey('\SOFTWARE\Microsoft\Windows NT\CurrentVersion', false) then
              begin
                if GetDataType('DigitalProductId') = rdBinary then
                  begin
                    PN := (ReadString('ProductName')) + ' 64 bit';;
                    PID := (ReadString('ProductID'));
                    binarySize := GetDataSize('DigitalProductId');
                    SetLength(HexBuf, binarySize);
                    if binarySize > 0 then
                      begin
                        ReadBinaryData('DigitalProductId', HexBuf[0], binarySize);
                      end;
                  end;
                CloseKey;
              end;
          finally
            free;
          end;
            Result := '';
              if pos('8',PN) > 0 then
                Result := DecodeWin8(HexBuf)
              else
                Result := DecodeProductKey(HexBuf);
        end;
    end;
end;

function BinToInt(Value: String): Integer;
var
  i, iValueSize: Integer;
begin
  Result := 0;
  iValueSize := Length(Value);
  for i := iValueSize downTo 1 do
    if Value[i] = '1' then
    begin
      Result := Result + (1 shl (iValueSize - i));
    end;
end;

function DecodeProductKey(Const HexSrc: Array Of Byte): String;
Const 
  StarToffset: Integer = $34;    {Offset 34 = Array Of Byte[52] }
  EndOffset: Integer = $34 + 15; {Offset 34 + 15(Bytes) = Array Of Byte[64] }
  Digits: Array[0..23] Of Char = ('B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'M', 'P', 'Q', 'R', 'T', 'V', 'W', 'X', 'Y', '2', '3', '4', '6', '7', '8', '9');
  dLen: Integer = 29;            {Length of Decoded Product Key }
  sLen: Integer = 15;            {Length of Encoded Product Key in Bytes (An Total of 30 in chars) }
var
  HexDigitalPID: Array Of Cardinal;
  Des          : Array Of Char;
  I            : Integer;
  N            : Integer;
  HN           : Cardinal;
  Value        : Cardinal;
begin 
  SetLength(HexDigitalPID, dLen); 
  For I := StarToffset To EndOffset Do
   begin 
       HexDigitalPID[I - StarToffSet] := HexSrc[I]; 
   end; 
  SetLength(Des, dLen + 1);

  For I := dLen - 1 Downto 0 Do
   begin 
       If (((I + 1) Mod 6) = 0) Then
        begin 
            Des[I] := '-'; 
        end
       else
        begin 
            HN := 0; 
            FOR N := sLen - 1 Downto 0 Do
             begin 
                 Value := (HN SHL 8) OR HexDigitalPID[N];
                 HexDigitalPID[N] := value Div 24;
                 HN := Value Mod 24;
             end; 
            Des[I] := Digits[HN]; 
        end; 
   end; 
  Des[dLen] := Chr(0); 

  For I := 0 To (Length(Des)-1) Do
   begin
       Result := Result + Trim(Des[I]);
   end; 
end;

function DecodeWin8(Const HexSrc: Array Of Byte): String;    //Win8   ungetestet
Const
  StarToffset: Integer = $34;    
  EndOffset: Integer = $34 + 17;
  Digits: Array[0..23] of Char = ('B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'M', 'P', 'Q', 'R', 'T', 'V', 'W', 'X', 'Y', '2', '3', '4', '6', '7', '8', '9');
  dLen: Integer = 29;           
  KeyOffset :Integer = 52 ;
var
  Key  : Array Of Cardinal;
  Cur  : Integer;
  X    : Integer;
  I    : Integer;
  K    : Integer;
  Last : Integer;
  T    : String;
begin
  I := 24;                                
  SetLength(Key, dLen);                   
    for K := StarToffset To EndOffset do   
      begin
        Key[K - StarToffSet] := HexSrc[K]; 
      end;
  Key[14] := BinToInt(IntToStr(Key[14])); 
    repeat                                
      Cur := 0;                          
      X := 14;                             
        repeat                            
          Cur := Cur * 256 ;               
          Cur := (Key[X]) + Cur;          
          Key[X] := Cur div 24 ;          
          Cur := Cur Mod 24;               
          X := X - 1;
        until X < 0;                      
      I := I - 1;                          
      Last := Cur;                        
      T := Digits[Cur] + T ;              
    until I < 0;                          
  T :=  Copy(T,2,25);                     
  Insert('N', T, Last + 1);                
    For X := 1 To 4 do                     
      begin
        Insert('-', T, X*6);               
      end;
  Result := T;                             
end;
//fr Key Auslesung 32 & 64 Bit ################################################

//******************************************************************************
//System:  Windows NT erkennen*
function isWindowsNT: Boolean;
var
  vi: TOSVersionInfo;
begin
  vi.dwOSVersionInfoSize := SizeOf(vi); GetVersionEx(vi);
  Result := vi.dwPlatformId = VER_PLATFORM_WIN32_NT;
end;

//****************** Sonstiges: Windows ProductID aus Registrie ****************
//Uses registry
function ProductNr: string;
var
  Reg: TRegistry;
begin
  ProductNr := '';
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    if
    Reg.OpenKey('\Software\Microsoft\Windows NT\CurrentVersion',False) then
    ProductNr := Reg.ReadString('Productid');
  finally
    Reg.Free;
  end;
end;
//************** Sonstiges: Windows ProductID aus Registrie Ende ***************

//Uses registry
function ProductCSDVersion: string;  //Servicepack
var
  Reg: TRegistry;
begin
  ProductCSDVersion := '';
  Reg := TRegistry.Create(KEY_READ OR $0100);
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    if
    Reg.OpenKey('\Software\Microsoft\Windows NT\CurrentVersion',False) then
    ProductCSDVersion := Reg.ReadString('CSDVersion');
  finally
    Reg.Free;
  end;
end;

//***************************** Windows - Version ermitteln ********************
//uses registry;
function GetWindowsVersion: string;
var
  VerInfo: TOsversionInfo;
  PlatformId, VersionNumber: string;
  Reg: TRegistry;
begin
  VerInfo.dwOSVersionInfoSize := SizeOf(VerInfo);
  GetVersionEx(VerInfo);
  // Detect platform
  Reg := TRegistry.Create;
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  case VerInfo.dwPlatformId of
  {  VER_PLATFORM_WIN32s:
      begin
        // Registry (Huh? What registry?)
        PlatformId := 'Windows 3.1';
      end;   }
    VER_PLATFORM_WIN32_WINDOWS:
      begin
        // Registry
        Reg.OpenKey('\SOFTWARE\Microsoft\Windows\CurrentVersion', False);
        PlatformId    := Reg.ReadString('ProductName');
        VersionNumber := Reg.ReadString('VersionNumber');
      end;
    VER_PLATFORM_WIN32_NT:
      begin
        // Registry
        Reg.OpenKey('\SOFTWARE\Microsoft\Windows NT\CurrentVersion', False);
        PlatformId    := Reg.ReadString('ProductName');
        VersionNumber := Reg.ReadString('CurrentVersion');
      end;
  end;
  Reg.Free;
  Result := PlatformId + '    (version: ' + VersionNumber + ')';
end;
//***************************** Windowa - Version ermitteln ********************

//#################### Namen einer Partition ermitteln #########################
function GetPartitionName(const ADrive: Char): String;
var
   unused: Cardinal; //oder Integer Delphi 3
   buffer: array[0..19] of Char;
begin
   Result:='';
   if (GetDriveType(PChar(Format('%S:\',[ADrive]) ) ) >1) and
      (GetVolumeInformation(PChar(ADrive +':\'),
       @buffer[0], SizeOf(buffer),nil,unused,unused,nil,0)) then
     Result := buffer
   else
    RaiseLastOSError;//Bis D5 RaiseLastWin32Error - ab D6 RaiseLastOSError;
end;
//#################### Namen einer Partition ermitteln #########################

//############# Grafikkartenspeicher - Video-Ram auslesen ######################
function GetWMIstring (wmiHost, wmiClass, wmiProperty : string):string;
var // These are all needed for the WMI querying process
   Locator: ISWbemLocator;
   Services: ISWbemServices;
   SObject: ISWbemObject;
   ObjSet: ISWbemObjectSet;
   SProp: ISWbemProperty;
   Enum: IEnumVariant;
   Value: Cardinal;
   TempObj: OleVariant;
   SN: string;
begin
   try
   Locator := CoSWbemLocator.Create;
    Services := Locator.ConnectServer(wmiHost, 'root\cimv2', '', '', '','', 0, nil);
   ObjSet := Services.ExecQuery('SELECT * FROM '+wmiClass, 'WQL',
     wbemFlagReturnImmediately and wbemFlagForwardOnly , nil);
   Enum := (ObjSet._NewEnum) as IEnumVariant;
   while (Enum.Next(1, TempObj, Value) = S_OK) do
   begin
     SObject := IUnknown(tempObj) as ISWBemObject;
     SProp := SObject.Properties_.Item(wmiProperty, 0);
     if VarIsNull(SProp.Get_Value) then
       result := ''
     else
     begin
       SN := SProp.Get_Value;
       result := SN;
     end;
   end;
   except // Trap any exceptions (Not having WMI installed will cause one!)
    on exception do
     result := '';
    end;
end;
//############# Grafikkartenspeicher - Video-Ram auslesen Ende #################

// Display-Frequenz ermitteln.
function GetDisplayFrequency: Integer;
var
  DeviceMode: TDeviceMode;
begin
  EnumDisplaySettings(nil, Cardinal(-1), DeviceMode);
  Result := DeviceMode.dmDisplayFrequency;
end;

//Zur Ermittlung der Farbtiefe 
function ScreenBitsPerPixel: Integer;
var
  DC: HDC;
begin
  DC := GetDC(0);  // Gertekontext des Desktops
  try
    Result := GetDeviceCaps(DC, BITSPIXEL);
  finally
    ReleaseDC(0, DC);
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
const
  DRIVE_UNKNOWN = 0;    //fr Laufwerkserkennung
  DRIVE_NO_ROOT_DIR = 1;//fr Laufwerkserkennung
  DRIVE_REMOVABLE = 2;  //fr Laufwerkserkennung
  DRIVE_FIXED = 3;      //fr Laufwerkserkennung
  DRIVE_REMOTE = 4;     //fr Laufwerkserkennung
  DRIVE_CDROM = 5;      //fr Laufwerkserkennung
  DRIVE_RAMDISK = 6;    //fr Laufwerkserkennung
var
   D: TDisplayDevice;  //fr Grafikkarte auslesen
   F: DWORD;           //fr Grafikkarte auslesen
   W: DWORD;           //fr Grafikkarte auslesen
   SizeX, SizeY: DWORD;// fr aktuelle Auflsung
   Status: TMemoryStatusEx; //fr Speicherermittlung
   r: LongWord;                   //fr Laufwerkserkennung
   Drives: array[0..128] of char; //fr Laufwerkserkennung
   pDrive: PChar;                 //fr Laufwerkserkennung
   free,total : Int64;            //fr Laufwerksgre
   BitsPerPixel: Integer;         //fr Farbtiefe
begin
  //fr Transparentes Fenster :-))
  //                  Form1.Brush.Style:=bsClear;
  //                  Form1.BorderStyle:=bsNone;
  //fr Transparentes Fenster :-))
  
   BitsPerPixel := ScreenBitsPerPixel;    //fr Farbtiefe
   
  //Programm starten mit Adminrechten, damit auch alles angezeigt wird.
  //uses ShellAPI;
  ShellExecute(Handle, 'RUNASADMIN', 'cmd.exe', nil, nil, SW_SHOWNORMAL);
  //Programm starten mit Adminrechten, Ende

   GetDiskFreeSpaceEx('C:\', free, total, nil);  //fr Laufwerksgre
  //fr Laufwerkserkennung
  r := GetLogicalDriveStrings(SizeOf(Drives), Drives);
  if r = 0 then Exit;
  if r > SizeOf(Drives) then
    raise Exception.Create(SysErrorMessage(ERROR_OUTOFMEMORY));
  pDrive := Drives;
  while pDrive^ <> #0 do
  begin
    if GetDriveType(pDrive) = DRIVE_FIXED then          //Laufwerke
       Form1.ComboBox1.Items.Add('Lw '+ pDrive);
    if GetDriveType(pDrive) = DRIVE_CDROM then          //CD-Rom / DVD-Rom
       Form1.ComboBox1.Items.Add('CD/DVD '+ pDrive);
    if GetDriveType(pDrive) = DRIVE_REMOVABLE then      //SD-Karte / USB-Sick / Diskettenlaufwerk / Wechseldatentrger 
       Form1.ComboBox1.Items.Add('SD/USB '+ pDrive);
    if GetDriveType(pDrive) = DRIVE_REMOTE then         //Netzwerk-Laufwerk
       Form1.ComboBox1.Items.Add(pDrive);
    if GetDriveType(pDrive) = DRIVE_NO_ROOT_DIR then    //
       Form1.ComboBox1.Items.Add(pDrive);
    Inc(pDrive, 4);
  end;
  //fr Laufwerkserkennung

  //cpu
  Label8.Caption:= 'Prozessorname:     ' +  GetProzessorName;
  Label9.Caption:= 'Prozessorkerne:    ' +  IntToStr(GetCPUCnt())+ ' Stck';
  Label10.Caption:= 'CPU Speed:         ' +  GetCpuSpeed;
  Label11.Caption:= 'Hersteller:            ' +  GetBioshersteller;
  Label12.Caption:= 'Identifizierung:      ' +  GetIdentifier;

  //Mainboard
  Label13.Caption:= 'Bord-Hersteller:      ' +  GetBordhersteller;
  Label14.Caption:= 'Serie:                    ' +  GetBordserie;
  Label15.Caption:= 'Biosversion:           ' +  GetBordBiosversion;
  Label16.Caption:= 'Biosdatum:             ' +  GetBordBiosdatum;
  Label41.Caption:= 'Bioshersteller:        ' +  BiosVendor;

  //Bios
   Label4.Caption:= 'Identifizierung:             ' + Biosidentifizierung;
   Label5.Caption:= 'Bios Datum:                 ' + BiosDateXp;
   Label6.Caption:= 'Video Bios Datum:        ' + VideoBiosDateXp;
   Label7.Caption:= 'System Bios Datum:      ' + Biosversion;

   //Betriebssystem
   if isWindowsNT = True then
   Label20.caption := 'Version:              NT Version'
 else
   Label20.caption := 'Version:              9x Version';

   Label21.Caption:= 'Produktschl.:       ' + View_Win_Key;                //View_Win_Key  //32bit & 64bit Version

   Label23.Caption:= 'Betriebssystem:    ' + GetWindowsVersion;

   Label45.caption:= 'Servicepack:       ' + ProductCSDVersion;

   Label46.caption := 'Systemsprache:    ' + Sprache;


   if IsWow64 = True then
   Label25.Caption:= 'Systemtyp:          64 Bit-Betriebssystem   '
   else
   Label25.Caption:= 'Systemtyp:          32 Bit-Betriebssystem   ';


   //Grafikkarte auslesen
   //  memo1.Clear;     //bei verwendung von Memo
   D.cb := sizeof(D);
   F := 0;   //sizeof(F);
   W := 0;   //sizeof(W);
   while EnumDisplayDevices(nil, W, D, F) do
   begin
     Label18.Caption:= '';
     Inc(F);
     //  memo1.lines.add(D.DeviceString);  //bei verwendung von Memo
     Label18.caption := 'Grafikkarte:             ' + D.DeviceString;
     break;          //damit nur GrafikKarte angezeigt wird - ein Durchlauf
   end;

   //aktuelle Auflsung
    SizeX := Screen.Width;                        // fr Auflsung Weite
    SizeY := Screen.Height;                       // fr Auflsung Hhe
    Label22.Caption:= 'aktuelle Auflsung:   ' + IntToStr(SizeX) + '  X  ' + IntToStr(SizeY);
    Label42.caption := 'Display Frequenz:     ' + IntToStr(GetDisplayFrequency)+' (Hz)';

    Label28.Caption:= 'Produkt-ID:          ' + ProductNr;  //OEM Version

   //fr Speicherermittlung & Ausgabe
    ZeroMemory(@Status, SizeOf(TMemoryStatusEx));
    Status.dwLength := SizeOf(TMemoryStatusEx);
    GlobalMemoryStatusEx(Status);
    Label26.Caption := 'Total RAM:             ' + IntToStr(Status.ullTotalPhys div 781264 )+ ' MB';
    Label27.Caption := 'Verfgbar RAM:       ' + IntToStr(Status.ullAvailPhys div 1048576 )+ ' MB';
    Label29.Caption := 'Total Pagefile:         ' + IntToStr(Status.ullTotalPageFile div 1048576 )+ ' MB';
    Label30.Caption := 'Verfgbar Pagefile:  ' + IntToStr(Status.ullAvailPageFile div 1048576 )+ ' MB';
    Label31.Caption := 'Total Virtuell:          ' + IntToStr(Status.ullTotalVirtual div 1048576 )+ ' MB';
    Label32.Caption := 'Verfgbar Virtuell:    ' + IntToStr(Status.ullAvailVirtual div 1048576 )+ ' MB';

    //fr Farbtiefenermittlung
    case BitsPerPixel of
     4: Label44.caption :='Farben && Farbtiefe:   ' + '16 (4 Bit Farbtiefe)';
     8: Label44.caption :='Farben && Farbtiefe:   ' + '256 (8 Bit Farbtiefe)';
    16: Label44.caption :='Farben && Farbtiefe:   ' + '64K, High Color (16 Bit Farbtiefe)';
    24: Label44.caption :='Farben && Farbtiefe:   ' + '16M, True Color (24 Bit Farbtiefe)';
    32: Label44.caption :='Farben && Farbtiefe:   ' + '16M, True Color (32 Bit Farbtiefe)';
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Form1.close;
end;

//################### Laufwerksgre feststellen ###############################
//uses SysUtils;
function GetDiskSize(drive: Char; var free_size, total_size : Int64): Boolean;
var
  RootPath: array[0..26] of Char;
  RootPtr: PChar;
  current_dir: string;
begin
  RootPath[0] := Drive;
  RootPath[1] := ':';
  RootPath[2] := '\';
  RootPath[3] := #0;
  RootPtr := RootPath;
  current_dir := GetCurrentDir;
  if SetCurrentDir(Drive + ':\') then
  begin
    GetDiskFreeSpaceEx(RootPtr, Free_size, Total_size, nil);
    // zurck zum ursprnglichen Verzeichnis
    SetCurrentDir(current_dir);
    Result := True;
  end
 else
  begin
    Result := False;
    Free_size  := -1;
    Total_size := -1;
  end;
end;
//################### Laufwerksgre feststellen ###############################

procedure TForm1.DriveComboBox1Change(Sender: TObject);
var
  free_size, total_size: Int64;
begin
   if GetDiskSize(DriveComboBox1.Drive, free_size, total_size) then
   Label38.Caption :=('Laufwerk ' + Uppercase(DriveComboBox1.Drive) + ':\' + GetPartitionName(DriveComboBox1.Drive) + ^J^J +
  'Grsse: = ' + FormatFloat('###,###,###'+ ' MB',total_size )+ ^J +
  'Frei:      = ' + FormatFloat('###,###,###'+' MB', free_size )+ ^J +
  'Belegt:  = ' + FormatFloat('###,###,###'+' MB', total_size - free_size ))
 else
  Label38.Caption :='keine Disk - CD im Laufwerk!';
end;
//################### Laufwerksgre feststellen ###############################

//################### Netz - Batterie/Ladestatus immer aktuell #################
procedure TForm1.Timer1Timer(Sender: TObject);
var
  SystemPowerStatus: TSystemPowerStatus; //fr Batteriestatus
begin
  //fr Batteriestatus  Netz - Batteriebetrieb
  GetSystemPowerStatus(SystemPowerStatus);
  with SystemPowerStatus do
  begin
  // Wird das System mit Netz oder Akku betrieben ?
    case AcLineStatus of
      0: Form1.Label33.Caption := 'System wird mit Akku betrieben';  //Offline
      1: Form1.Label33.Caption := 'System luft auf Netzbetrieb';    //Online
    else
     Form1.Label33.Caption := 'Unbekannter Status';
  end;
   //fr Batteriestatus  Netz - Batteriebetrieb
   
   // Ladezustand der Batterie
    case BatteryFlag of
      1 : Label39.Caption := 'Hoher Ladezustand';
      2 : Label39.Caption := 'Niedriger Ladezustand';
      4 : Label39.Caption := 'Kritischer Ladezustand';
      8 : Label40.Caption := 'Die Batterie wird geladen';
      //9 : Label40.caption := 'Batterie wird ber Netzteil geladen';			//Batterie ist gesund & wird ber Netzteil geladen
      128: Label39.Caption := 'Es existiert keine System-Batterie';
      255: Label39.Caption := 'Unbekannter Status';
    end;

   // Ladezustand in Prozent
    if BatteryLifePercent <> 255 then
      Label34.Caption := 'Ladezustand der Batterie: ' + IntToStr(BatteryLifePercent) + ' %'
    else
      Label34.Caption := 'Unbekannter Status';
    end;
    // Ladezustand in Prozent
   end;
//################### Netz - Batterie/Ladestatus immer aktuell #################

//############## Grafikkartenspeicher bei Form1-Aktivierung auslesen ###########
procedure TForm1.FormActivate(Sender: TObject);
var tmpstr : string;
    s      : Integer;
begin
   tmpstr := getWMIstring('','Win32_VideoController ','AdapterRAM');
   if tmpstr <> '' then s := StrToInt(tmpstr);
   Label43.caption := 'VideoRAM:              ' + IntTostr(s div 1024 div 1024) +' KB ' ;
end;
//######## Grafikkartenspeicher bei Form1-Aktivierung auslesen Ende ############

end.
