unit Unit1;         //D.B. Batteriestatus 20.03.2014

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ShellAPI, Menus, Commctrl;

const
  WM_TASKABAREVENT = WM_USER+1; //fr Taskbar message Treyicon neben Uhr

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Timer2: TTimer;
    Label4: TLabel;
    PopupMenu1: TPopupMenu;
    Form1verstecken1: TMenuItem;
    Form1zeigen1: TMenuItem;
    Form1Ende1: TMenuItem;
    Timer3: TTimer;
    Hilfe1: TMenuItem;
    procedure Timer1Timer(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);  
    procedure Form1Ende1Click(Sender: TObject);
    procedure Form1verstecken1Click(Sender: TObject);
    procedure Form1zeigen1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Timer3Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Hilfe1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  procedure TaskbarEvent(var Msg: TMessage); //Taskbar message Treyicon neben Uhr
  Message WM_TASKABAREVENT;                  //Taskbar message Treyicon neben Uhr

  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{Message-Prozedur fr das TrayIcon}
procedure TForm1.TaskbarEvent(var Msg: TMessage);
var Point : TPoint;
 SystemPowerStatus: TSystemPowerStatus; //fr Batteriestatus
begin
  { Die WM_TaskbarEvent-Message "Msg" gibt in Msg.LParam
    das genaue Ereignis an. Msg.LParam kann folgende Werte fr
    Mausereignisse annehmen:

    WM_MouseMove
    WM_LButtonDown
    WM_LButtonUp
    WM_LButtonDblClk
    WM_RButtonDown
    WM_RButtonUp
    WM_RButtonDblClk }

  { Eventhandler-Beispiele von Robert Fischer: }
  case Msg.LParam of
    WM_MouseMove:    //Popupmen TrackButton WM_MouseMove:
      begin
        //Mach etwas nach einem MouseMove...
      end;
     WM_RBUTTONUP:  //Popupmen TrackButton WM_RBUTTONUP:
      begin
        //Mach etwas nach einem Buttonklick...
        Form1.Hide;
        begin
          Timer3.Enabled := True;    //MessageDlg schliesst nach 8 Sek oder durch Button.click
          //fr Batteriestatus
          GetSystemPowerStatus(SystemPowerStatus);
          with SystemPowerStatus do
          MessageDlg('Batteriestatus:        ' + IntToStr(BatteryLifePercent) + ' %' +
          #13#10 + 'Fenster schliet in 8 Sek.', mtInformation,[mbOk],0);
         // ShowMessage('Batteriestatus: ' + IntToStr(BatteryLifePercent) + ' %');
        end;
      end;  
    WM_LBUTTONUP:   //Popupmen TrackButton WM_LBUTTONUP:
      begin
        // Diese Zeile ist wichtig, damit das PopupMenu korrekt
        // wieder geschlossen wird:
        SetForegroundWindow(Handle);
        // PopupMenu anzeigen:
        GetCursorPos(Point);
        PopupMenu1.Popup(Point.x, Point.y);
        //oder ohne Variable Point:
        //PopupMenu1.Popup(Mouse.CursorPos.x, Mouse.CursorPos.y);
      end;
  end;
end;

{TrayIcon mit dem Hauptformular zerstren}
procedure TForm1.FormDestroy(Sender: TObject);
var
  NotifyIconData: TNotifyIconData;
begin
  FillChar(NotifyIconData,Sizeof(NotifyIconData),0);
  NotifyIconData.cbSize := Sizeof(NotifyIconData);
  NotifyIconData.Wnd    := Self.Handle;
  NotifyIconData.uFlags := NIF_MESSAGE
  or NIF_ICON
  or NIF_TIP;
  NotifyIconData.uCallbackMessage := WM_TASKABAREVENT;
  NotifyIconData.hIcon := Application.Icon.Handle;
  NotifyIconData.szTip := 'Punkt';
  Shell_NotifyIcon(NIM_DELETE, @NotifyIconData);
end;

//########################### Mglichkeit1 #####################################
function SecToTime(Sec: integer): string;
var
   H, M, S: string;
   ZH, ZM, ZS: Integer;
begin
  if Sec  < 0 then
  begin
    Result := 'Keine';    //Netzanschluss
    exit;
  end;

   ZH := Sec div 3600;
   ZM := Sec div 60 - ZH * 60;
  // ZS := Sec - (ZH * 3600 + ZM * 60) ;
   H := IntToStr(ZH) ;
   M := IntToStr(ZM) ;
  // S := IntToStr(ZS) ;
   Result := H + ':' + M;  // + ':' + S;
end;

Function getPowerStatus:String;    //fr Form1 - Anzeige
var
  SysPowerStatus: TSystemPowerStatus;
begin
  GetSystemPowerStatus(SysPowerStatus);
  if Boolean(SysPowerStatus.ACLineStatus) then
  begin
    Result := 'System luft auf Netzbetrieb: ';
  end
else
  begin
    result := 'System wird mit Akku betrieben: ';
  end;
  result := result + #13#10 + 'Ladezustand der Batterie: ' + intToStr(SysPowerStatus.BatteryLifePercent) + ' %' + #13#10 +
                      'Restlaufzeit: ' + SecToTime(SysPowerStatus.BatteryLifeTime)+' ( h:m )'; {+ #13#10 +
                      'Batteryflag: ' + getBatteryflag(SysPowerStatus.BatteryFlag);   }
end;
//########################### Mglichkeit1 #####################################

//########################### Mglichkeit2 #####################################
Function getPowerStatus1:String;//fr Application.Title in Statuszeile - Anzeige
var
  SysPowerStatus: TSystemPowerStatus;
begin
  GetSystemPowerStatus(SysPowerStatus);
{  if Boolean(SysPowerStatus.ACLineStatus) then
  begin
    Result := 'System luft auf Netzbetrieb: ';
  end
else
  begin
    result := 'System wird mit Akku betrieben: ';
  end;  }
  result := result + SecToTime(SysPowerStatus.BatteryLifeTime);
end;
//########################### Mglichkeit2 #####################################

//################### Netz - Batterie/Ladestatus immer aktuell #################
procedure TForm1.Timer1Timer(Sender: TObject);
var
   SystemPowerStatus: TSystemPowerStatus; //fr Batteriestatus
begin
    //fr Batteriestatus
  GetSystemPowerStatus(SystemPowerStatus);
  with SystemPowerStatus do
  begin
  // Wird das System mit Netz oder Akku betrieben ?
    case ACLineStatus of
 {     0: Form1.Label1.Caption := 'System wird mit Akku betrieben';  //Offline
      1: Form1.Label1.Caption := 'System luft auf Netzbetrieb';    //Online
     else
      Form1.Label1.Caption := 'Unbekannter Status';
    end;
   //fr Batteriestatus

   // Ladezustand der Batterie
    case BatteryFlag of
      1 :  begin
             Label3.Color := clGreen; //Batteriekapazitt ist hher 66%
             Label3.Caption := 'Hoher Ladezustand: < 66%'; //Anzeige nur im Akkubetrieb
           end;
      2 : begin
             Label3.Color := clyellow; //Batteriekapazitt weniger als 33%
             Label3.Caption := 'Niedriger Ladezustand: > 33%';
          end;
      4 : begin
             Label3.Color := clred; //Batteriekapazitt auf weniger als 5%
             Label3.Caption := 'Kritischer Ladezustand: > 5%';
          end;
      8 :  Label3.Caption := 'Die Batterie wird geladen';//nur bei Netzanschluss
      128: Label3.Caption := 'Es existiert keine System-Batterie';               }
      255: //Label3.Caption := 'Unbekannter Status';
    end;
    // Ladezustand der Batterie
//################### Netz - Batterie/Ladestatus immer aktuell #################    

   // Ladezustand in Prozent
    if BatteryLifePercent <> 255 then
    begin
{      Label2.Caption := 'Ladezustand der Batterie: ' + IntToStr(BatteryLifePercent) + ' %';// + 'Laufzeit: ' + IntToStr(BatteryLifeTime)
      Label3.Caption := 'Restlaufzeit ' + IntToStr(BatteryLifeTime div 3600);   }
      Label4.caption :=  getPowerStatus;
    end
    else
  //    Label2.Caption := 'Unbekannter Status';
    end;
    // Ladezustand in Prozent
end;
//################### Batterie/Ladestatus immer aktuell ########################
procedure TForm1.Timer2Timer(Sender: TObject);
var
   SystemPowerStatus: TSystemPowerStatus; //fr Batteriestatus
begin
   //fr Batteriestatus
  GetSystemPowerStatus(SystemPowerStatus);
  with SystemPowerStatus do
  // Ladezustand in Prozent
    if BatteryLifePercent <> 255 then
    Application.Title := 'Stat: '+IntToStr(BatteryLifePercent) + '% ' + ' Time '+ getPowerStatus1;
  // Ladezustand in Prozent
end;
//################### Batterie/Ladestatus immer aktuell ########################

//#################### Anwendung/Form1 Create ##################################
procedure TForm1.FormCreate(Sender: TObject);
var
  NotifyIconData: TNotifyIconData;                //fr Treyicon neben Uhr
begin
  ShowWindow(Application.Handle, SW_HIDE);       //Icon in Statusleiste ausblenden
  SetWindowLong(Application.Handle, GWL_EXSTYLE, //Icon in Statusleiste ausblenden
  GetWindowLong(Application.Handle, GWL_EXSTYLE) //Icon in Statusleiste ausblenden
  or WS_EX_TOOLWINDOW and not WS_EX_APPWINDOW);  //Icon in Statusleiste ausblenden
  ShowWindow(Application.Handle, SW_SHOW);       //Icon in Statusleiste ausblenden

  Fillchar(NotifyIconData,Sizeof(NotifyIconData),0);//fr Treyicon neben Uhr
  NotifyIconData.cbSize := Sizeof(NotifyIconData);  //fr Treyicon neben Uhr
  NotifyIconData.Wnd    := Handle;                  //fr Treyicon neben Uhr
  NotifyIconData.uFlags := NIF_MESSAGE              //fr Treyicon neben Uhr
    or NIF_ICON                                     //fr Treyicon neben Uhr
    or NIF_TIP;                                     //fr Treyicon neben Uhr
  NotifyIconData.uCallbackMessage := WM_TASKABAREVENT;//fr Treyicon neben Uhr
  NotifyIconData.hIcon := Application.Icon.Handle;    //fr Treyicon neben Uhr
  NotifyIconData.szTip := 'Hinweistext fr das TrayIcon';//fr Treyicon neben Uhr
  Shell_NotifyIcon(NIM_ADD, @NotifyIconData);           //fr Treyicon neben Uhr

 // Application.OnMiniMize := AppMiniMize;//Anwendung - Form1 Minimiert starten
  Form1.WindowState := wsNormal;     //Form1 kreieren und anzeigen
  Form1zeigen1.enabled := false;     //Anzeige Popupmenue ausblenden
end;
//#################### Anwendung/Form1 Create ##################################

//###################### Popupmen1 Form1 schliessen ###########################
procedure TForm1.Form1Ende1Click(Sender: TObject);
begin
  Form1.close;
end;

//#################### Popupmen1 Form1 verstecken #############################
procedure TForm1.Form1verstecken1Click(Sender: TObject);
begin
  Form1.Hide;
  Form1verstecken1.enabled := false;  //Anzeige Popupmenue ausblenden
  Form1zeigen1.enabled := true;       //Anzeige Popupmenue einblenden
end;

//################### Popupmen1 Form1 zeigen ##################################
procedure TForm1.Form1zeigen1Click(Sender: TObject);
begin
  Form1.Show;
  Form1zeigen1.enabled := false;      //Anzeige Popupmenue ausblenden
  Form1verstecken1.enabled := true;   //Anzeige Popupmenue einblenden
end;

//################ damit keine Grennderung von Form1 geht ###################
procedure TForm1.FormResize(Sender: TObject);
begin
  If Width > 190 Then Width := 190;
  If Height > 115 Then Height := 115;
end;

//##################### auf Tastendruck reagieren ##############################
procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  If Key = 27 Then Form1.Hide; // 27 ESC Taste
  If Key = 121 Then Form1.close; // 121 oder vk_F10  F10 Taste
//  if (Key = VK_Escape) or (Key = VK_F10) then Form1.Hide;
end;

//############################## Hilfe wers denn braucht ######################
procedure TForm1.Hilfe1Click(Sender: TObject);
begin
  Timer3.Enabled := False;
 // MessageDlgPos('ESC = Fenster verstecken ' + #13 + 'F10 = Prog beenden ' ,mtConfirmation, mbYesNoCancel, 0, 200, 200);
  if MessageDlg('ESC = Fenster verstecken ' + #13 + 'F10 = Prog beenden ' + #13 + 'r-klick auf Icon = Info ',
    mtInformation, [mbYes], 0) = mrYes then
  begin
    MessageDlg('Info wird beendet!', mtInformation,
      [mbOk], 0);
   // Close;      
  end;        
end;

//Fenster nach eingestellter Zeit ( 8 Sek. ) schliessen
procedure TForm1.Timer3Timer(Sender: TObject);
begin
  Timer3.Enabled := False;
  PostMessage(FindWindow(PChar('TMessageForm'), nil), WM_CLOSE, 0, 0);
  Form1zeigen1.enabled := true;      //Anzeige Popupmenue ausblenden
  Form1verstecken1.enabled := false;   //Anzeige Popupmenue einblenden
end;

end.

