unit Unit1;//D.B. 03.2014 Arbeitsspeicher auslesen - getestet unter Win 7/32 Bit

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

//fr Speicherermittlung########################################################
type
  TMemoryStatusEx = packed record
    dwLength: DWORD;
    dwMemoryLoad: DWORD;
    ullTotalPhys: Int64;
    ullAvailPhys: Int64;
    ullTotalPageFile: Int64;
    ullAvailPageFile: Int64;
    ullTotalVirtual: Int64;
    ullAvailVirtual: Int64;
    ullAvailExtendedVirtual: Int64;
  end;
//fr Speicherermittlung########################################################  

var
  Form1: TForm1;

implementation

{$R *.dfm}

//fr Speicherermittlung########################################################
function GlobalMemoryStatusEx(var lpBuffer: TMemoryStatusEx): BOOL; stdcall; external kernel32;
//fr Speicherermittlung########################################################

procedure TForm1.FormCreate(Sender: TObject);
var
Status: TMemoryStatusEx; //fr Speicherermittlung
begin
  //fr Speicherermittlung & Ausgabe
    ZeroMemory(@Status, SizeOf(TMemoryStatusEx));
    Status.dwLength := SizeOf(TMemoryStatusEx);
    GlobalMemoryStatusEx(Status);
    Label1.Caption := 'Total RAM:               ' + IntToStr(Status.ullTotalPhys div 781264 )+ ' MB';
    Label2.Caption := 'Verfgbar RAM:       ' + IntToStr(Status.ullAvailPhys div 1048576 )+ ' MB';
    Label3.Caption := 'Total Pagefile:         ' + IntToStr(Status.ullTotalPageFile div 1048576 )+ ' MB';
    Label4.Caption := 'Verfgbar Pagefile: ' + IntToStr(Status.ullAvailPageFile div 1048576 )+ ' MB';
    Label5.Caption := 'Total Virtuell:            ' + IntToStr(Status.ullTotalVirtual div 1048576 )+ ' MB';
    Label6.Caption := 'Verfgbar Virtuell:    ' + IntToStr(Status.ullAvailVirtual div 1048576 )+ ' MB';
end;

end.



